FF(1)                       UNIX User's Manual             February 7, 1987

NAME
     ff - fast text formatter

USAGE
     ff [options] [-] [files]

DESCRIPTION
     _f_f is a simple text formatter for flexible uniform formatting of input
     files.  Program options are used to control formatting.  This is in
     contrast to text formatters like _n_r_o_f_f (_1) that require special format
     requests to be part of their input files.  Besides avoiding cryptic
     format requests in text, _f_f is considerably faster than traditional
     formatters like _n_r_o_f_f (_1) and even simple formatters like _f_m_t (_1).

     The most complicated concept with _f_f is that of a line break.  A line
     break causes an interruption in the filling (evening out of the text
     lines).  Line breaks occur when special characters are seen at the
     beginnings of lines, or when all lines are broken.  By default, any
     non-alphanumeric character will cause a break, but this can be
     controlled with the -B option.  A blank line always causes a break.

OPTIONS
     There are many, many options to allow control of indentation, line
     width, line spacing, filling, pagination with headers and footers,
     line numbering, right justification, and perhaps some other things.
     They have extensive type and range checking that produces diagnostic
     error messages, so warnings of obviously wrong options will not be
     discussed here.  In general, options that imply the use of others work
     the way they should; if the page size is set, then pagination is
     automatically assumed.  Some combinations of options give impressive,
     even artistic, effects.  Making a small text file and playing with it
     is the easiest way to learn how the options interact.

     -b   Break all lines of text.  That is, don't even-out lines by
          filling.  By default, text lines are filled.

     -B breakchars
          Change the set of characters that cause line breaks at the start
          of lines to _b_r_e_a_k_c_h_a_r_s. By default, any characters but letters
          and numbers cause a break.  A good choice for break characters
          might be "*-+" and TABS that might be used for lists.

     -c   Center all lines of text.  This option stops all filling of text.

     -d   Delete white space at the beginning and end of lines.  This
          option is useful to help un-format text to be re-formatted.

     -D   Delete empty input lines.  An input line is empty if it has no
          characters, not even invisible character like tabs or spaces.
          This option can be combined with the option to remove white space
          to delete visibly blank lines.

     -f footer
          Set the page footer to the title-string _f_o_o_t_e_r. The default page
          footer is blank.  Titles can be any string, but if the first
          character is not a letter or a digit, but a punctuation character
          like /, then that character separates the left, center, and right
          fields of a title.  For example, the title
                            "/ff: fast formatter/#/1985/"
          would have "ff: fast formatter" as a left justified field and
          1985 as a right justified field on each page.  The page number,
          within the input file, would be centered in the title.  There are
          two special characters, # and *, that respectively are variables
          for the page number in a file and the input file name.  The
          global page number, which is not reset for each file, is ##.
               There is a whole language that allows you to insert
          information about the file being printed.  You can see online
          help for this language by running the command:
                                     echo | ff -f %?
          It is a complicated language, but you can avoid it by avoiding
          the percent (%) character in titles.

     -F footersize
          Set the number of blank lines at the bottom of the page.  The
          footer, if any, is placed in the middle of the space, which by
          default, is five lines.  If _f_o_o_t_e_r_s_i_z_e is 0, no footer will be
          printed.

     -h header
          Set the page header.  See the description of three-part titles
          for the -f footer option.  The default page header is
                                "|File: *||Page: #|".

     -H headersize
          See the description of the footer size.

     -i indent
          Set the indentation of the text to _i_n_d_e_n_t spaces.  Note that this
          effectively reduces the usable width of the page.

     -I tempindent
          Set the temporary indent.  This causes filled text found
          immediately after a break to be indented for one line.  It is
          useful for indenting the first lines of paragraphs.  If
          _t_e_m_p_i_n_d_e_n_t is negative, the the temporary indent will be relative
          to the current _i_n_d_e_n_t value.  If the _t_e_m_p_i_n_d_e_n_t value is more
          negative than the _i_n_d_e_n_t value is positive, _f_f will automatically
          increase _i_n_d_e_n_t.

     -j   Justify the text.  That is, even the right margin by inserting
          spaces in the line.  Only filled text can be justified.

     -n   Number all output lines produced by the input text.  Lines from
          multiple line spacing or pagination will not be numbered.

     -N numberwidth
          Set the width of the line numbers.  The default is to take up 4
          spaces.  Note that this effectively reduces the usable part of
          the page.

     -O   Print a summary of all the options and stop.

     -p   Paginate the output.  See the options for page header and footer
          control.

     -P pagesize
          Set the number of lines in a page to _p_a_g_e_s_i_z_e. By default, the
          standard 66 line page is assumed.

     -s spacing
          Set the line spacing.  By default, text is single spaced (_s_p_a_c_i_n_g
          equals 1).

     -t tab
          Set individual absolute and relative tab stops.  These values
          tell the formatter where to put the text (from an unfilled line)
          that follows a tab character.  Each tab stop is supplied with its
          own -t option; there is no way to bundle them.  _t_a_b values can be
          integers without a plus sign.  These are _a_b_s_o_l_u_t_e tab settings;
          the tabs go to that position.  The values must increase
          monotonically.  If a _t_a_b value is preceded by a plus sign, then
          it is interpreted _r_e_l_a_t_i_v_e to the previous tab setting.  For
          example, a tab setting of 40 followed by one of +20 will set the
          second tab stop to 60.

     -T tabs
          Set tab stops to every _t_a_b_s spaces.  It is useful to get equally
          spaced tabs.  This option cannot be used with the other tab
          setting option.

     -u   Print All Input Text As Initial Upper-Case Titles, Like This
          Sentence.  This option goes well with the one for centering
          lines.

     -w width
          Set the page width.  By default, the page width is 72 characters.
          Note that the usable line length is sometimes less than the page
          width.  If line numbering or indentation is requested, these
          subtract from the line length.

EXAMPLES
     Some of these examples can make shell scripts or aliases.

     Centered Titles: title
          ff  -dcu  $*
     Double Spaced Unfilled Paginated indented (for editing): draft
          ff  -s 2  -b  -p  -f "`date`"  -i 8  $*
     Program Listing: cpr
          H="@        Dir: `pwd`@@File: *@"
          F="@        $NAME@`date`@Page #@"
          ff  -b  -N 8  -H 3  -h "$H"  -F 3  -f "$F"  -T 4  -w 79  -i 2  $*
     Reformat Paragraphed Text: nr
          ff  -jd  -I 5  -i 10  -w 65  -B "TAB SP'*.@"  $*

DIAGNOSTICS
     Some options are incompatible with others.  For example, centered text
     cannot be right-justified.  _f_f will not allow inconsistent
     combinations of options.

SEE ALSO
     fmt(1), nroff(1), scribe(1w)

AUTHOR
     Gary Perlman (with help from many students)

STATUS
     Pretty well tested.
