package edu.cornell.cs.cs4120.eth;

public abstract class AbstractOutputController {
    public void startTest(Test t) {
        if (t instanceof ScriptTestSuite) startScriptTestSuite((ScriptTestSuite) t);
        else if (t instanceof SourceFileTestCollection)
            startSourceFileTestCollection((SourceFileTestCollection) t);
        else if (t instanceof SourceFileTest) startSourceFileTest((SourceFileTest) t);
        else if (t instanceof BuildTest) startBuildTest((BuildTest) t);
    }

    public void finishTest(Test t) {
        if (t instanceof ScriptTestSuite) finishScriptTestSuite((ScriptTestSuite) t);
        else if (t instanceof SourceFileTestCollection)
            finishSourceFileTestCollection((SourceFileTestCollection) t);
        else if (t instanceof SourceFileTest) finishSourceFileTest((SourceFileTest) t);
        else if (t instanceof BuildTest) finishBuildTest((BuildTest) t);
    }

    protected abstract void startScriptTestSuite(ScriptTestSuite t);

    protected abstract void startSourceFileTestCollection(SourceFileTestCollection t);

    protected abstract void startSourceFileTest(SourceFileTest t);

    protected abstract void startBuildTest(BuildTest t);

    protected abstract void finishScriptTestSuite(ScriptTestSuite t);

    protected abstract void finishSourceFileTestCollection(SourceFileTestCollection t);

    protected abstract void finishSourceFileTest(SourceFileTest t);

    protected abstract void finishBuildTest(BuildTest t);
}
